function [fitresult, gof] = Create_Surface_Fit_5(AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10, LacZ_output_pED_IPTG_INS_log10)
%CREATESURFACEFIT(AHL_INPUT_PED_IPTG_INS_LOG10,IPTG_INPUT_PED_IPTG_INS_LOG10,LACZ_OUTPUT_PED_IPTG_INS_LOG10)
%  Fit surface to data.
%
%  Data for 'untitled fit 1' fit:
%      X Input : AHL_input_pED_IPTG_INS_log10
%      Y Input : IPTG_input_pED_IPTG_INS_log10
%      Z output: LacZ_output_pED_IPTG_INS_log10
%      Weights : (none)
%
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.

%  Auto-generated by MATLAB on 07-Apr-2011 10:06:54

%% Initialization.

% Convert all inputs to column vectors.
AHL_input_pED_IPTG_INS_log10 = AHL_input_pED_IPTG_INS_log10(:);
IPTG_input_pED_IPTG_INS_log10 = IPTG_input_pED_IPTG_INS_log10(:);
LacZ_output_pED_IPTG_INS_log10 = LacZ_output_pED_IPTG_INS_log10(:);

%% Fit: 'untitled fit 1'.
ft = fittype( '(bottom1 + (top1 - bottom1) / (1+10^((LogEC50_1 - x)))) * Bottom + (Top-Bottom)/(1+10^((LogIC50-y)*HillSlope))', 'indep', {'x', 'y'}, 'depend', 'z' );
opts = fitoptions( ft );
opts.Algorithm = 'Levenberg-Marquardt';
opts.Display = 'Off';
opts.Lower = [-Inf -Inf -Inf -Inf -Inf -Inf -Inf];
opts.StartPoint = [0.76 0.155 2 0.5537 0.7565 0.65798 0.59499];
opts.Upper = [Inf Inf Inf Inf Inf Inf Inf];
opts.Weights = zeros(1,0);
[fitresult, gof] = fit( [AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10], LacZ_output_pED_IPTG_INS_log10, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, [AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10], LacZ_output_pED_IPTG_INS_log10 );
legend( h, 'untitled fit 1', 'LacZ_output_pED_IPTG_INS_log10 vs. AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10', 'Location', 'NorthEast' );
% Label axes
xlabel( 'AHL_input_pED_IPTG_INS_log10' );
ylabel( 'IPTG_input_pED_IPTG_INS_log10' );
zlabel( 'LacZ_output_pED_IPTG_INS_log10' );
grid on
view( -106.5, 88 );


